% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_image.R
\name{locate_image}
\alias{locate_image}
\title{Locate needle image position on a screenshot image.}
\usage{
locate_image(
  needle_image,
  center = TRUE,
  exact = TRUE,
  timeout = 5,
  corner = NULL,
  width = 600,
  height = 300,
  size = NULL,
  scale = NULL,
  bin_dir = ""
)
}
\arguments{
\item{needle_image}{A string of image file path or
a cimg class object of imager library.}

\item{center}{A logical. TRUE returns center position of needle_image.}

\item{exact}{A logical. Check matching exactly or not.}

\item{timeout}{A numeric for timeout seconds.}

\item{corner}{A string to specify a corner of the display.
"top_left", "top_right", "bottom_left", or "bottom_right".}

\item{width, height}{A integer to specify width or height of the corner.}

\item{size}{Integers to specify width or height of display size.}

\item{scale}{A numeric to specify display scale.}

\item{bin_dir}{A string for directory name of screenshot.exe on Win.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   A numeric pair of xy location.
}\if{html}{\out{</div>}}
}
\description{
Locate needle image position on a screenshot image.
}
\examples{
\dontrun{
sc <- screenshot()
if(sc != ""){
  sc_image <- imager::load.image(sc)
  w <- 100
  h <- 80
  pos_x <- 1
  pos_y <- imager::height(sc_image) - h
  needle <- crop_image(sc_image, pos_x, pos_y, w, h)
  (locate_image(needle)) # center location
  pos <- locate_image(needle, center = FALSE)
  found <- crop_image(sc_image, pos[1], pos[2], w, h)
  layout(c(1:3))
  plot(sc_image)
  plot(needle)
  plot(found)
  # usse `coner` to limit searching field
  # `coner` can be used in Windows
  pos <- locate_image(needle, corner = "bottom_left", center = FALSE)
}
}

}
