% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_sdl_methods.R
\name{residuals.sdlrm}
\alias{residuals.sdlrm}
\title{Extract Model Residuals for a Modified Skew Discrete Laplace Regression Fit}
\usage{
\method{residuals}{sdlrm}(object, type = c("quantile", "pearson", "response"), ...)
}
\arguments{
\item{object}{an object of class \code{"sdlrm"}, a result of a call to \code{\link{sdlrm}}.}

\item{type}{character; specifies which residual should be extracted.
The available arguments are \code{"quantile"} (randomized quantile
residuals; default), \code{"pearson"} (Pearson residuals, i.e., (y - mean) / sd),
and \code{"response"} (raw residuals, i.e., y - mean).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector with the required residuals.
}
\description{
Residuals resulting from fitting a modified Laplace discrete skew regression.
}
\examples{
## Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

## Fit with a model only for the mean (mode = 1)
fit <- sdlrm(difference ~ group, data = pss, xi = 1)

## Randomized quantile residuals
rq <- residuals(fit)

## Pearson residuals
rp <- residuals(fit, type = "pearson")

## Raw response residuals
rr <- residuals(fit, type = "response")

cbind(quantile = rq, pearson = rp, raw = rr)
}
