% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche_synthese.R
\encoding{utf-8}
\name{nicheSynthese}
\alias{nicheSynthese}
\title{nicheSynthese}
\usage{
nicheSynthese(env.stack, config, stack = FALSE, random.error = FALSE)
}
\arguments{
\item{env.stack}{a \code{rasterStack} object that contain the environment variable}

\item{config}{config is a \code{list} or \code{matrix} or \code{data.frame} that contain config info, details see details part}

\item{stack}{stack is an option that if you want not compose them togethor (result return as a \code{rasterStack}). Default is FALSE}

\item{random.error}{add random error on cell or not. Default is FALSE}
}
\value{
\code{rasterLayer} or \code{rasterStack} if stack is set to TRUE
}
\description{
niche synthese method
}
\details{
This method mainly implement niche synthese method, for more details see references

You can write several paragraphs.
}
\examples{
# load the sdmvspecies library
library("sdmvspecies")
library("raster")
# find package's location
package.dir <- system.file(package="sdmvspecies")
# let see where is our sdmvspecies is installed in
package.dir
# find env dir under the package's location
env.dir <- paste(package.dir, "/external/env/", sep="")
# let see env dir
env.dir
# get the environment raster file
env.files <- list.files(env.dir, pattern="*.bil$", full.names=TRUE)
# see the file list
env.files
# put the environment file in a raster stack,
# which require all the environment should have same resolution and extend
env.stack <- stack(env.files)
# let see the env.stack var
env.stack
# here let's configure the environment response function and weight
config <- list(
    c("bio1","1",2),
    c("bio14", "2", 2),
    c("bio5", "3", 1),
    c("bio11", "4", 2),
    c("bio16", "5", 1)
)
# call the niche synthsis method
species.raster <- nicheSynthese(env.stack, config)
# let see the result raster,
# you should noticed that it's continue value map not distributin map
species.raster

# write the map to file, so you can use it latter in GIS software
# or further analysis.
#
#writeRaster(species.raster, "synthese.img", "HFA", overwrite=TRUE)

# to make binary distribution map, you should chosee a threshold to make map
# see the map then to decide the threshold to binary
plot(species.raster)
# choice threshold, here we choice 4
threshold <- 14
# make binary map
distribution.map <- species.raster > threshold
# plot the map out
plot(distribution.map)
}
\references{
Hirzel, A. H., Helfer, V., & Metral, F. (2001). Assessing habitat-suitability models with a virtual species. Ecological modelling, 145(2), 111-121.
}

