% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_median.R
\encoding{utf-8}
\name{pickMedian}
\alias{pickMedian}
\title{pickMedian}
\usage{
pickMedian(env.stack, subset = NULL, stack = FALSE)
}
\arguments{
\item{env.stack}{a \code{rasterStack} object that contain the environment variable}

\item{subset}{subset is a string \code{vector} that contain environment variables names which into calculate, if NULL that all var in env.stack will calculate.}

\item{stack}{stack is an option that if you want not compose them togethor (result return as a \code{rasterStack}). Default is FALSE}
}
\value{
\code{rasterLayer} or \code{rasterStack} if stack is set to TRUE
}
\description{
pick median method
}
\details{
This method mainly implement pick median method
}
\examples{
# load the sdmvspecies library
library("sdmvspecies")
library("raster")
# find package's location
package.dir <- system.file(package="sdmvspecies")
# let see where is our sdmvspecies is installed in
package.dir
# find env dir under the package's location
env.dir <- paste(package.dir, "/external/env/", sep="")
# let see env dir
env.dir
# get the environment raster file
files <- list.files(path=env.dir, pattern="*.bil$", full.names=TRUE)
# make raster stack
env.stack <- stack(files)
# run pick mean
species.raster <- pickMedian(env.stack)
# plot map
plot(species.raster)
}
\references{
Lobo, J. M., & Tognelli, M. F. (2011). Exploring the effects of quantity and location of pseudo-absences and sampling biases on the performance of distribution models with limited point occurrence data. Journal for Nature Conservation, 19(1), 1-7.
}

