% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_ds_partial_death_dates.R
\name{check_ae_ds_partial_death_dates}
\alias{check_ae_ds_partial_death_dates}
\title{Check for partial death dates in AE and DS}
\usage{
check_ae_ds_partial_death_dates(AE, DS, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID,AEDTHDTC,AEDECOD}

\item{DS}{Dispostion SDTM dataset with variables USUBJID,DSSCAT,DSSTDTC,DSDECOD}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This checks looks for partial death dates in AE and DS
}
\examples{

# test with sample data

AE <- data.frame(
 USUBJID = 1:3,
 AEDECOD = c("AE1","AE2","AE3"),
 AEDTHDTC = c("2017-01-01","2017",NA),
 AESPID = "FORMNAME-R:2/L:2XXXX",
 stringsAsFactors=FALSE
)

DS <- data.frame(
 USUBJID = 1:4,
 DSSCAT = "STUDY DISCON",
 DSDECOD = "DEATH",
 DSSTDTC = c("2017-01-01","2017","2017-01-02","2016-10"),
 stringsAsFactors=FALSE
)

check_ae_ds_partial_death_dates(AE,DS)
check_ae_ds_partial_death_dates(AE,DS,preproc=roche_derive_rave_row)

DS$DSSTDTC = NULL

check_ae_ds_partial_death_dates(AE,DS)

}
\author{
Will Harris
}
