% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_dsterm_death_due_to.R
\name{check_ds_dsterm_death_due_to}
\alias{check_ds_dsterm_death_due_to}
\title{Check missing cause of death information in DS}
\usage{
check_ds_dsterm_death_due_to(DS)
}
\arguments{
\item{DS}{Disposition SDTMv dataset with variables USUBJID, DSTERM, DSDECOD,
DSDTC, DSSTDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for DS.DSTERM values with missing death reason
and returns a data frame (e.g. records where DSTERM = 'DEATH DUE TO')
}
\examples{

DS <- data.frame(
 STUDYID = 1,
 USUBJID = 1:4,
 DSTERM = c("DEATH DUE TO",
   "DEATH DUE TO ",
   "DEATH DUE TO ADVERSE EVENT",
   "DEATH DUE TO UNKNOWN"),
 DSDECOD = "DEATH",
 DSDTC = "2017-01-01",
 DSSTDTC = "2017-01-01",
 stringsAsFactors=FALSE
)

check_ds_dsterm_death_due_to(DS)

DS$DSDECOD <- NULL
check_ds_dsterm_death_due_to(DS)

}
\author{
Sara Bodach
}
