% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dv_ae_aedecod_covid.R
\name{check_dv_ae_aedecod_covid}
\alias{check_dv_ae_aedecod_covid}
\title{Check for consistency between DV and AE for COVID-19 events}
\usage{
check_dv_ae_aedecod_covid(
  AE,
  DV,
  covid_terms = c("COVID-19", "CORONAVIRUS POSITIVE")
)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDECOD}

\item{DV}{Protocol Deviation SDTM dataset with variables USUBJID, DVREAS}

\item{covid_terms}{A length >=1 vector of AE terms identifying COVID-19 (case does not matter)}
}
\value{
boolean value if check returns 0 obs, otherwise return subset dataframe.
}
\description{
If a patient has a DV record indicating COVID-19 then they
should also have COVID-related AE where AE.AEDECOD matches covid.REFTERM.
}
\examples{

AE <- data.frame(
 USUBJID = 1:6,
 AEDECOD = c("pandemic", "covid-19","some AE","some AE","CORONAVIRUS POSITIVE","UNMAPPED")
)

DV <- data.frame(
 USUBJID = 1:6,
 DVREAS=c("SUSPECTED EPIDEMIC/PANDEMIC INFECTION",
          "UNKNOWN",
          "SUSPECTED EPIDEMIC/PANDEMIC INFECTION",
          "OTHER",
          "SUSPECTED EPIDEMIC/PANDEMIC INFECTION",
          "SUSPECTED EPIDEMIC/PANDEMIC INFECTION")
)

check_dv_ae_aedecod_covid(AE,DV)


# Pass specific covid terms

check_dv_ae_aedecod_covid(AE,DV,covid_terms=c("COVID-19", "CORONAVIRUS POSITIVE","PANDEMIC"))

}
\seealso{
Other COVID: 
\code{\link{check_ae_aeacn_ds_disctx_covid}()},
\code{\link{check_ae_aeacnoth_ds_stddisc_covid}()},
\code{\link{check_dv_covid}()}
}
\author{
Natalie Springfield
}
\concept{COVID}
\keyword{COVID}
