% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dv_covid.R
\name{check_dv_covid}
\alias{check_dv_covid}
\title{Check for consistency in COVID-19 DV variables, DVREAS and DVEPRELI}
\usage{
check_dv_covid(DV)
}
\arguments{
\item{DV}{Protocol Deviations SDTM dataset with variables USUBJID, DVREAS,
DVEPRELI}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for inconsistency between DVREAS and DVEPRELI.
If DVREAS indicates a COVID-19 related deviation, then DVEPRELI should not be
missing and vice versa. This check applies to studies using the Protocol
Deviation Management System (PDMS).
}
\examples{

DV <- data.frame(
    USUBJID = 1:3,
    DVEPRELI = c("Y","N","Y"),
    DVREAS=c("EPIDEMIC/PANDEMIC INFECTION","EPIDEMIC/PANDEMIC INFECTION",""),
    stringsAsFactors=FALSE
)

check_dv_covid(DV)

}
\seealso{
Other COVID: 
\code{\link{check_ae_aeacn_ds_disctx_covid}()},
\code{\link{check_ae_aeacnoth_ds_stddisc_covid}()},
\code{\link{check_dv_ae_aedecod_covid}()}
}
\author{
Mij Rahman
}
\concept{COVID}
\keyword{COVID}
