% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_exdosu.R
\name{check_ex_exdosu}
\alias{check_ex_exdosu}
\title{Check for missing EXDOSU records}
\usage{
check_ex_exdosu(EX)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID,EXTRT,EXSTDTC,EXDOSU}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing EXODOSU values for valid doses
}
\examples{

EX <- data.frame(
 USUBJID = 1:10,
 EXTRT = 1:10,
 EXSTDTC = 1:10,
 EXDOSE = 1:10,
 EXOCCUR = as.character(c(rep("Y",5),rep("N",5))),
 EXDOSU = as.character(rep("mg",10))
)

EX$EXDOSU[1] = ""
EX$EXDOSU[2] = "NA"
EX$EXDOSU[3] = NA

check_ex_exdosu(EX)

EX$EXSTDTC = NULL

check_ex_exdosu(EX)

}
\author{
Jen Chen
}
