% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_qs_dup.R
\name{check_qs_dup}
\alias{check_qs_dup}
\title{Check for multiple dates at the same visit in QS}
\usage{
check_qs_dup(QS)
}
\arguments{
\item{QS}{QS SDTM dataset with variables USUBJID, QSCAT, VISIT, QSDTC}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the test failed
}
\description{
Identifies multiple dates at the same visit in QS
}
\examples{

QS1 <- data.frame(USUBJID = c(rep(101, 5), rep(102, 5)),
                QSCAT = "DLQI",
                QSDTC = rep(c("2017-01-01T08:25", "2017-01-05T09:25",
                 "2017-01-15T10:25","2017-01-20T08:25","2017-01-25T08:25"), 2),
                VISITNUM = rep(1:5,2),
                VISIT = rep(c( "Visit 1", "Visit 2", "Visit 3", "UNSCheduled!!!","VIsit 5"), 2),
                stringsAsFactors = FALSE)
check_qs_dup(QS = QS1)

# multiple dates for the same visit in QS
QS2 <- QS1
QS2$VISIT[QS2$USUBJID == 101] <- "Visit 1"
check_qs_dup(QS = QS2)

# multiple visit labels for the same date
QS3 <- QS1
QS3$QSDTC[QS3$USUBJID == 101] <- "2017-01-01"
QS3
check_qs_dup(QS = QS3)


}
\author{
Yuliia Bahatska
}
