% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sc_dm_eligcrit.R
\name{check_sc_dm_eligcrit}
\alias{check_sc_dm_eligcrit}
\title{Check SC Eye Meeting Eligibility Criteria assignments among DM patients}
\usage{
check_sc_dm_eligcrit(DM, SC)
}
\arguments{
\item{DM}{Subject Demographics SDTM dataset with variable USUBJID}

\item{SC}{Subject Characteristics SDTM dataset for Ophtho Study with variables
USUBJID, SCTESTCD, SCTEST, SCCAT, SCORRES, SCDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
Check if SC.SCCAT = "STUDY EYE SELECTION" and SC.SCTESTCD = "ELIGEYE",
then SC.SCORRES should have "OS", "OD", or "OU" values. Flag if subject is in
DM and without an associated SC.SCORRES value or the ELIGEYE Eye Meeting
Eligibility Criteria value is not "OS", "OD", or "OU".
}
\examples{

dm <- data.frame(USUBJID = c(1,2))
sc <- data.frame(USUBJID  = c(1,1,1,2,2,2),
                 SCTEST   = c("Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest",
                              " ",
                              "Eye Meeting Eligibility Criteria",
                              "Focus of Study-Specific Interest", " "),
                 SCTESTCD = c("ELIGEYE", "FOCID", "", "ELIGEYE", "FOCID", ""),
                 SCCAT    = c("STUDY EYE SELECTION",
                              "STUDY EYE SELECTION",
                              "",
                              "STUDY EYE SELECTION",
                              "STUDY EYE SELECTION",
                              ""),
                 SCORRES  = c("OS", "OS", "", "", "OU", ""),
                 SCDTC    = rep("2021-01-01", 6),
                 stringsAsFactors = FALSE)

check_sc_dm_eligcrit(SC=sc, DM=dm)

dm <- data.frame(USUBJID = c(1,2,3,4))
sc$SCORRES[4] = "OS"
check_sc_dm_eligcrit(SC=sc, DM=dm)

sc$SCORRES <- NULL
check_sc_dm_eligcrit(SC=sc, DM=dm)


}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat_prior_ocular}()},
\code{\link{check_cm_cmlat}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_vs_1m_req}()},
\code{\link{check_oe_bcva_tot_mismatch}()},
\code{\link{check_oe_sc_lat_count_fingers}()},
\code{\link{check_pr_prlat}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Monarch Shah (HackR 2021 Team Eye)
}
\concept{OPHTH}
\keyword{OPHTH}
