% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{assign_SEQ}
\alias{assign_SEQ}
\title{Assign SEQ numbers for a SDTM data set}
\usage{
assign_SEQ(tbl, key_vars, seq_prefix, USUBJID = "USUBJID")
}
\arguments{
\item{tbl}{a data frame, the SDTM table}

\item{key_vars}{a character vector of the key variables to sort by}

\item{seq_prefix}{a string, the prefix for SEQ as per the spec (usually the
two letter domain abbreviation)}

\item{USUBJID}{a string, the column for the subject ID, USUBJID, default is
\code{"USUBJID"}}
}
\value{
a sorted copy of the \code{tbl} data frame with the new SEQ column
}
\description{
Assigns the \code{"[DOMAIN]SEQ"} number by sorting the data set by the specified
variables and then grouping by \code{"USUBJID"}.
}
\examples{
df <- data.frame(
  USUBJID = paste("Subject", c(rep(1, 3), rep(2, 3))),
  XXTESTCD = paste("T", rep(c(2, 3, 1), 2))
)
assign_SEQ(df, key_vars = c("USUBJID", "XXTESTCD"), seq_prefix = "XX")

}
