% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{get_key_vars}
\alias{get_key_vars}
\title{Read in the key variables for a SDTM domain}
\usage{
get_key_vars(
  domain,
  dir,
  filename,
  datasets_sheet = "Datasets",
  dataset_col = "Dataset",
  keyvar_col = "Key Variables"
)
}
\arguments{
\item{domain}{string, SDTM domain or supplemental domain code}

\item{dir}{string, specification directory}

\item{filename}{string, file name of the specification}

\item{datasets_sheet}{a string, the sheet name in the specification Excel
file that has the key variables, default is \code{"Datasets"}}

\item{dataset_col}{a string, the column name of the domains in the table in
\code{datasets_sheet}, default is \code{"Dataset"}}

\item{keyvar_col}{a string, the column name of the key variables in the table
in \code{datasets_sheet}, default is \code{"Key Variables"}}
}
\value{
a character vector of key variables for the specified \code{domain}
}
\description{
Reads the \code{"Key Variables"} column from the SDTM specification MS Excel
file's \code{"Datasets"} sheet for the specified \code{domain}.
}
\details{
The \code{readxl::read_excel()} function will causes an access denied warning when
reading in a read-only specification file. This does not affect the data
import.
}
\examples{
work_dir <- system.file("extdata", package = "sdtmval")
key_vars <- get_key_vars(domain = "XX",
                         dir = work_dir,
                         filename = "spec.xlsx")

}
\seealso{
\code{\link[=get_data_spec]{get_data_spec()}}, \code{\link[=get_codelist]{get_codelist()}}, \code{\link[=assign_meta_data]{assign_meta_data()}}
}
