% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-core.R
\name{SearchAnalyzer}
\alias{SearchAnalyzer}
\title{Search Strategy Analytics Engine}
\description{
The SearchAnalyzer class provides a comprehensive framework for analyzing
the performance of systematic review search strategies. It calculates
precision, recall, and other performance metrics, generates visualizations,
and supports validation against gold standard datasets.
}
\details{
Core class for analyzing systematic review search strategies

This R6 class encapsulates all functionality needed for search strategy
analysis. Key capabilities include:
\itemize{
\item Performance metric calculation (precision, recall, F1, efficiency)
\item Temporal and database coverage analysis
\item Visualization generation for reports
\item Gold standard validation
}
}
\section{Methods}{

\describe{
\item{\code{new(search_results, gold_standard, search_strategy)}}{Initialize analyzer}
\item{\code{calculate_metrics()}}{Calculate comprehensive performance metrics}
\item{\code{visualize_performance(type)}}{Generate performance visualizations}
}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{search_results}}{Data frame containing search results}

\item{\code{gold_standard}}{Reference set of relevant articles}

\item{\code{metadata}}{Search strategy metadata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SearchAnalyzer-new}{\code{SearchAnalyzer$new()}}
\item \href{#method-SearchAnalyzer-calculate_metrics}{\code{SearchAnalyzer$calculate_metrics()}}
\item \href{#method-SearchAnalyzer-visualize_performance}{\code{SearchAnalyzer$visualize_performance()}}
\item \href{#method-SearchAnalyzer-clone}{\code{SearchAnalyzer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchAnalyzer-new"></a>}}
\if{latex}{\out{\hypertarget{method-SearchAnalyzer-new}{}}}
\subsection{Method \code{new()}}{
Initialize the analyzer with search results and optional gold standard.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchAnalyzer$new(
  search_results,
  gold_standard = NULL,
  search_strategy = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_results}}{Data frame with search results}

\item{\code{gold_standard}}{Vector of known relevant article IDs}

\item{\code{search_strategy}}{List containing search parameters}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, called for side effects
Calculate comprehensive performance metrics
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchAnalyzer-calculate_metrics"></a>}}
\if{latex}{\out{\hypertarget{method-SearchAnalyzer-calculate_metrics}{}}}
\subsection{Method \code{calculate_metrics()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchAnalyzer$calculate_metrics()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of performance metrics
Generate performance visualization
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchAnalyzer-visualize_performance"></a>}}
\if{latex}{\out{\hypertarget{method-SearchAnalyzer-visualize_performance}{}}}
\subsection{Method \code{visualize_performance()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchAnalyzer$visualize_performance(type = "overview")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Type of visualization}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchAnalyzer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SearchAnalyzer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchAnalyzer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
