% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_single_branch.R
\name{secsse_single_branch_loglik}
\alias{secsse_single_branch_loglik}
\title{Likelihood for SecSSE model
Loglikelihood calculation for the SecSSE model given a set of parameters and
data, calculated for a single branch}
\usage{
secsse_single_branch_loglik(
  parameter,
  phy,
  traits,
  num_concealed_states,
  cond = "proper_cond",
  root_state_weight = "proper_weights",
  sampling_fraction,
  setting_calculation = NULL,
  see_ancestral_states = FALSE,
  loglik_penalty = 0,
  is_complete_tree = FALSE,
  take_into_account_root_edge = FALSE,
  num_threads = 1,
  atol = 1e-08,
  rtol = 1e-07,
  method = "odeint::bulirsch_stoer",
  display_warning = TRUE,
  use_normalization = TRUE
)
}
\arguments{
\item{parameter}{list where first vector represents lambdas, the second
mus and the third transition rates.}

\item{phy}{phylogenetic tree of class \code{phylo}, rooted and with
branch lengths. Alternatively, multiple phylogenetic trees can be provided
as the \code{multiPhylo} class.}

\item{traits}{vector with trait states for each tip in the phylogeny. The
order of the states must be the same as the tree tips. For help, see
\code{vignette("starting_secsse", package = "secsse")}. When providing a
\code{multiPhylo} set of multiple phylognies, traits should be a list where
each entry in the list corresponds to the matching phylogeny on that
position.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to the number of examined states in the dataset.}

\item{cond}{condition on the existence of a node root: \code{"maddison_cond"},
\code{"proper_cond"} (default). For details, see vignette.}

\item{root_state_weight}{the method to weigh the states:
\code{"maddison_weights"}, \code{"proper_weights"} (default) or \code{"equal_weights"}.
It can also be specified for the root state: the vector \code{c(1, 0, 0)}
indicates state 1 was the root state. When
using a \code{multiPhylo} object, root_state_weight should be list where each
entry in the list corresponds to the root_state_weight for each tree.}

\item{sampling_fraction}{vector that states the sampling proportion per
trait state. It must have as many elements as there are trait states. When
using a \code{multiPhylo} object, sampling fraction should be list where each
entry in the list corresponds to the sampling proportion for each tree.}

\item{setting_calculation}{argument used internally to speed up calculation.
It should be left blank (default : \code{setting_calculation = NULL}).}

\item{see_ancestral_states}{Boolean for whether the ancestral states should
be shown? Defaults to \code{FALSE}.}

\item{loglik_penalty}{the size of the penalty for all parameters; default is
0 (no penalty).}

\item{is_complete_tree}{logical specifying whether or not a tree with all its
extinct species is provided. If set to \code{TRUE}, it also assumes that all
\emph{all} extinct lineages are present on the tree. Defaults to \code{FALSE}.}

\item{take_into_account_root_edge}{if TRUE, the LL integration is continued
along the root edge. This also affects conditioning (as now, conditioning
no longer needs to assume a speciation event at the start of the tree)}

\item{num_threads}{number of threads to be used. Default is one thread.}

\item{atol}{A numeric specifying the absolute tolerance of integration.}

\item{rtol}{A numeric specifying the relative tolerance of integration.}

\item{method}{integration method used, available are:
\code{"odeint::runge_kutta_cash_karp54"}, \code{"odeint::runge_kutta_fehlberg78"},
\code{"odeint::runge_kutta_dopri5"}, \code{"odeint::bulirsch_stoer"} and
\code{"odeint::runge_kutta4"}. Default method is: \code{"odeint::bulirsch_stoer"}.}

\item{display_warning}{display a warning if necessary}

\item{use_normalization}{normalize the density vector during integration,
more accurate but slower (default = TRUE)}
}
\value{
The loglikelihood of the data given the parameter.
}
\description{
Likelihood for SecSSE model
Loglikelihood calculation for the SecSSE model given a set of parameters and
data, calculated for a single branch
}
