% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual_recruitment.R
\name{annual_recruitment}
\alias{annual_recruitment}
\title{Returns a data.frame showing the annual recruitment per center}
\usage{
annual_recruitment(x, rm_regex = "")
}
\arguments{
\item{x}{a \code{secuTrialdata} object}

\item{rm_regex}{character - specifies a regular expression to be removed from the centre names in the legend.
e.g. rm_regex = "\\\(.*\\\)$" will remove trailing brackets and their contents.}
}
\value{
a data.frame showing the annual recruitment counts per center
}
\description{
secuTrial exports inherently contain the information on which participant was
             registered at which point in time. This function makes use of this property
             to show annual recruitment.
}
\note{
This function wraps plot_recruitment to retrieve the data.
}
\examples{
# export location
expot_loc <- system.file("extdata", "sT_exports", "lnames",
                         "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                         package = "secuTrialR")
# read export
sT_export <- read_secuTrial(expot_loc)

# plot recruitment
annual_recruitment(sT_export)

# show without trailing bracket
annual_recruitment(sT_export, rm_regex = "\\\\(.*\\\\)$")

}
