% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seedr.R
\docType{package}
\name{seedr}
\alias{seedr}
\title{seedr: Hydro and Thermal Time Seed Germination Models in R}
\description{
The \code{seedr} package provides functions to fit hydro and thermal time
germination models. These models characterize seed lots by two sets of
parameters: (i) the physiological thresholds (water, temperature) between
which the seed lot can germinate, and (ii) the physiological-time units that
the seed lot needs to accumulate before it can germinate. \code{seedr} allows
to fit the hydro time model of Bradford (Gummerson 1986, Bradford 1990,
Bewley et al. 2013) and the thermal time model of Garcia-Huidobro
(Garcia-Huidobro et al. 1982, Gummerson 1986, Bewley et al. 2013).
\code{seedr} also allows to quickly fit models to multi-seedlot or
multi-species datasets.
}
\references{
Bewley, J. D., Bradford, K. J., Hilhorst, H. W., & Nonogaki, H.
  (2013). Environmental Control of Germination. In Seeds: Physiology of
  Development, Germination and Dormancy, 3rd Edition (pp. 302-317). Springer,
  New York, NY.

  Bradford, K. J. (1990). A water relations analysis of seed germination
  rates. Plant Physiology, 94(2), 840-849.

  Garcia-Huidobro, J., Monteith, J. L., & Squire, G. R. (1982). Time,
  temperature and germination of pearl millet (Pennisetum typhoides S. & H.)
  I. Constant temperature. Journal of Experimental Botany, 33(2), 288-296.

  Gummerson, R. J. (1986). The effect of constant temperatures and osmotic
  potentials on the germination of sugar beet. Journal of Experimental
  Botany, 37(6), 729-741.
}
