% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/segen.R
\docType{package}
\name{segen}
\alias{segen}
\alias{segen-package}
\title{segen}
\usage{
segen(
  df,
  seq_len = NULL,
  similarity = NULL,
  dist_method = NULL,
  rescale = NULL,
  smoother = FALSE,
  ci = 0.8,
  error_scale = "naive",
  error_benchmark = "naive",
  n_windows = 10,
  n_samp = 30,
  dates = NULL,
  seed = 42,
  use_parallel = FALSE,
  parallel_workers = NULL
)
}
\arguments{
\item{df}{data.frame of time features (all numeric OR all categorical).}

\item{seq_len}{integer, forecasting horizon. If NULL, auto-sampled.}

\item{similarity}{numeric in (0,1), similarity quantile. If NULL, sampled.}

\item{dist_method}{character. Options:
"euclidean","manhattan","maximum","minkowski","correlation","dtw".
If NULL, sampled from available methods (skips 'dtw' if pkg missing).}

\item{rescale}{logical, rescale weights before normalization.}

\item{smoother}{logical, apply loess smoothing for numeric features.}

\item{ci}{numeric in (0,1), confidence level.}

\item{error_scale}{"naive" or "deviation".}

\item{error_benchmark}{"naive" or "average".}

\item{n_windows}{integer, rolling validation windows.}

\item{n_samp}{integer, random search samples.}

\item{dates}{Date vector aligned with rows of df (optional).}

\item{seed}{integer, RNG seed.}

\item{use_parallel}{logical, use furrr/future for parallel exploration.}

\item{parallel_workers}{NULL or integer, number of workers when parallel.}
}
\value{
list with exploration, history, best_model, time_log.

This function returns a list including:
\itemize{
\item exploration: list of all not-null models, complete with predictions and error metrics
\item history: a table with the sampled models, hyper-parameters, validation errors
\item best_model: results for the best selected model according to the weighted average rank, including:
\itemize{
\item predictions: for continuous variables, min, max, q25, q50, q75, quantiles at selected ci, mean, sd, mode, skewness, kurtosis, IQR to range, risk ratio, upside probability and divergence for each point fo predicted sequences; for factor variables, min, max, q25, q50, q75, quantiles at selected ci, proportions, difformity (deviation of proportions normalized over the maximum possible deviation), entropy, upgrade probability and divergence for each point fo predicted sequences
\item testing_errors: testing errors for each time feature for the best selected model (for continuous variables: me, mae, mse, rmsse, mpe, mape, rmae, rrmse, rame, mase, smse, sce, gmrae; for factor variables: czekanowski, tanimoto, cosine, hassebrook, jaccard, dice, canberra, gower, lorentzian, clark)
\item plots: standard plots with confidence interval for each time feature
}
\item time_log
}
}
\description{
Sequence Generalization Through Similarity Network
}
\examples{
segen(time_features[, 1, drop = FALSE], seq_len = 30, similarity = 0.7, n_windows = 3, n_samp = 1)


}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/segen}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}

\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]

}
