% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_maxima_positions.r, R/flag_minima_positions.r
\name{flag_maxima_positions}
\alias{flag_maxima_positions}
\alias{flag_minima_positions}
\title{Detect local maxima/minima of a numeric vector}
\usage{
flag_maxima_positions(values)

flag_minima_positions(values)
}
\arguments{
\item{values}{numeric vector of values}
}
\value{
logical vector with TRUE at the center of local maxima/minima
}
\description{
Fast detection of local maxima and minima of a numeric vector.
This function takes a numeric vector as input and returns a logical vector with the
same length and TRUE values at local maxima/minima (depending on function).
If multiple succeeding values at a local maximum/minimum are equal, then only
the center (rounded up if necessary) of the maximum/minimum is marked with TRUE.
}
\examples{
var <- c(1,2,3,3,2,1,4,5,6,7,5,4,3)

## Using the Maxima functions
flag_maxima_positions(var)

# values of maxima
var[flag_maxima_positions(var)]

# indices of maxima
which(flag_maxima_positions(var))


## Using the Minima functions
flag_minima_positions(var)

# values of maxima
var[flag_minima_positions(var)]

# indices of maxima
which(flag_minima_positions(var))
}

