% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{multivariate}
\alias{multivariate}
\title{Efficient Logarithmic Discrete Multivariate Likelihood estimation}
\usage{
multivariate(data, na_action = function(d) d[, colSums(is.na(d)) == 0,
  drop = FALSE])
}
\arguments{
\item{data}{Matrix to estimate the multivariate of. Each row is considered to
be an observation, and each column is considered to be a different
variable.}

\item{na_action}{A function that is applied to the \code{data} parameter. Defaults to
removing columns with NA.}
}
\value{
the estimate of the Discrete Maximum Likelihood for the dataframe
provided.
}
\description{
Estimate the likelihood of a given segment using the discrete multivariate
estimation, implemented efficiently in C++
}
\details{
Calculates the discrete log likelihood multivariate estimation of a data
matrix using an algorithm implemented in C++ for performance. This is
intended to be used in conjunction with \code{\link[=segment]{segment()}}, as the log likelihood
function is executed multiple times, which makes it the bottleneck of the
computation. Because the multivariate is so commonly used, this efficient
implementation is provided.
}
