% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_segmentr.R
\name{print.segmentr}
\alias{print.segmentr}
\title{Print a segmentr object}
\usage{
\method{print}{segmentr}(x, ...)
}
\arguments{
\item{x}{an object of type segmentr, containing change point information}

\item{...}{further arguments to be passed down to other methods}
}
\description{
Prints a short description of the segments found in the \code{segmentr} object
}
\details{
A short representation of the segments is printed on the screen, using the
\code{start:end} range notation.
}
\examples{
make_segment <- function(n, p) matrix(rbinom(100 * n, 1, p), nrow = 100)
data <- cbind(make_segment(5, 0.1), make_segment(10, 0.9), make_segment(2, 0.1))
mean_lik <- function(X) abs(mean(X) - 0.5) * ncol(X)^2
x <- segment(data, likelihood = mean_lik, algorithm = "hieralg")
print(x)
}
