% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq.R
\name{chisq_gl}
\alias{chisq_gl}
\alias{chisq_gl4}
\title{Chi-Sq for GL}
\usage{
chisq_gl(gl, g1, g2)

chisq_gl4(gl, g1, g2)
}
\arguments{
\item{gl}{A matrix of offspring genotype log-likelihoods. The rows index the
individuals and the columns index the possible genotypes. So
\code{gl[i, k]} is the offspring genotype log-likelihood for individual i and
genotype k-1.}

\item{g1}{The first parent's genotype.}

\item{g2}{The second parent's genotype.}
}
\value{
A list containing the chi-squared statistic, degrees of
freedom, and p-value.
}
\description{
Calculates the MLE genotype and runs a chi-squared test assuming
no double reduction and no preferential pairing.
}
\section{Functions}{
\itemize{
\item \code{chisq_gl4()}: Alias for chisq_gl, for backwards compatibility.

}}
\examples{
## null sim
set.seed(1)
g1 <- 2
g2 <- 2
gl <- simf1gl(n = 25, g1 = g1, g2 = g2, alpha = 0, xi2 = 1/3)
chisq_gl(gl = gl, g1 = g1, g2 = g2)

}
\author{
Mira Thakkar and David Gerard
}
