% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt_glpknown.R
\name{like_glpknown_2}
\alias{like_glpknown_2}
\title{Likelihood under three parameter model when using offspring genotypes
likelihoods but parent genotypes are known.}
\usage{
like_glpknown_2(gl, alpha, xi1, xi2, g1, g2, log_p = TRUE)
}
\arguments{
\item{gl}{The matrix of genotype likelihoods of the offspring. Rows index
The individuals, columns index the genotypes.}

\item{alpha}{The double reduction rate.}

\item{xi1}{The preferential pairing parameter of parent 1.}

\item{xi2}{The preferential pairing parameter of parent 2.}

\item{g1}{Parent 1's genotype.}

\item{g2}{Parent 2's genotype.}

\item{log_p}{A logical. Should we return the log likelihood or not?}
}
\value{
The (log) likelihood of the two parameter model when using
genotype likelihoods.
}
\description{
This is under the two parameter model.
}
\examples{
g1 <- 1
g2 <- 0
gl <- simf1gl(
  n = 25,
  g1 = g1,
  g2 = g2,
  rd = 10,
  alpha = 0,
  xi1 = 1/3,
  xi2 = 1/3)
like_glpknown_2(
  gl = gl,
  alpha = 0.01,
  xi1 = 0.5,
  xi2 = 0.3,
  g1 = g1,
  g2 = g2,
  log_p = TRUE)

}
\author{
David Gerard
}
