% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.groupfs.R
\name{groupfs}
\alias{groupfs}
\title{Select a model with forward stepwise.}
\usage{
groupfs(x, y, index, maxsteps, sigma = NULL, k = 2, intercept = TRUE,
  center = TRUE, normalize = TRUE, aicstop = 0, verbose = FALSE)
}
\arguments{
\item{x}{Matrix of predictors (n by p).}

\item{y}{Vector of outcomes (length n).}

\item{index}{Group membership indicator of length p. Check that \code{sort(unique(index)) = 1:G} where \code{G} is the number of distinct groups.}

\item{maxsteps}{Maximum number of steps for forward stepwise.}

\item{sigma}{Estimate of error standard deviation for use in AIC criterion. This determines the relative scale between RSS and the degrees of freedom penalty. Default is NULL corresponding to unknown sigma. When NULL, \code{link{groupfsInf}} performs truncated F inference instead of truncated \eqn{\chi}. See \code{\link[stats]{extractAIC}} for details on the AIC criterion.}

\item{k}{Multiplier of model size penalty, the default is \code{k = 2} for AIC. Use \code{k = log(n)} for BIC, or \code{k = 2log(p)} for RIC (best for high dimensions, when \eqn{p > n}). If \eqn{G < p} then RIC may be too restrictive and it would be better to use \code{log(G) < k < 2log(p)}.}

\item{intercept}{Should an intercept be included in the model? Default is TRUE. Does not count as a step.}

\item{center}{Should the columns of the design matrix be centered? Default is TRUE.}

\item{normalize}{Should the design matrix be normalized? Default is TRUE.}

\item{aicstop}{Early stopping if AIC increases. Default is 0 corresponding to no early stopping. Positive integer values specify the number of times the AIC is allowed to increase in a row, e.g. with \code{aicstop = 2} the algorithm will stop if the AIC criterion increases for 2 steps in a row. The default of \code{\link[stats]{step}} corresponds to \code{aicstop = 1}.}

\item{verbose}{Print out progress along the way? Default is FALSE.}
}
\value{
An object of class "groupfs" containing information about the sequence of models in the forward stepwise algorithm. Call the function \code{\link{groupfsInf}} on this object to compute selective p-values.
}
\description{
This function implements forward selection of linear models almost identically to \code{\link[stats]{step}} with \code{direction = "forward"}. The reason this is a separate function from \code{\link{fs}} is that groups of variables (e.g. dummies encoding levels of a categorical variable) must be handled differently in the selective inference framework.
}
\examples{
x = matrix(rnorm(20*40), nrow=20)
index = sort(rep(1:20, 2))
y = rnorm(20) + 2 * x[,1] - x[,4]
fit = groupfs(x, y, index, maxsteps = 5)
out = groupfsInf(fit)
out
}
\seealso{
\code{\link{groupfsInf}}, \code{\link{factorDesign}}.
}

