% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMI.R
\name{runMI-deprecated}
\alias{runMI-deprecated}
\alias{lavaan.mi-deprecated}
\alias{cfa.mi-deprecated}
\alias{sem.mi-deprecated}
\alias{growth.mi-deprecated}
\title{Fit a lavaan Model to Multiple Imputed Data Sets}
\usage{
runMI(model, data, fun = "lavaan", ...,
      m, miArgs = list(), miPackage = "Amelia", seed = 12345)

lavaan.mi(model, data, ...,
          m, miArgs = list(), miPackage = "Amelia", seed = 12345)

cfa.mi(model, data, ...,
       m, miArgs = list(), miPackage = "Amelia", seed = 12345)

sem.mi(model, data, ...,
       m, miArgs = list(), miPackage = "Amelia", seed = 12345)

growth.mi(model, data, ...,
          m, miArgs = list(), miPackage = "Amelia", seed = 12345)
}
\arguments{
\item{model}{The analysis model can be specified using
\code{\link[lavaan:model.syntax]{lavaan::model.syntax()}} or a \code{\link[lavaan:parTable]{lavaan::parTable()}}}

\item{data}{A \code{data.frame} with missing observations, or a \code{list}
of imputed data sets (if data are imputed already). If \code{runMI()} has
already been called, then imputed data sets are stored in the
\verb{@DataList} slot, so \verb{data=} can also be an \code{OLDlavaan.mi} object
from which the same imputed data will be used for additional analyses.}

\item{fun}{\code{character}. Name of a specific lavaan function used to fit
\verb{model=} to \verb{data=} (i.e., \code{"lavaan"}, \code{"cfa"}, \code{"sem"}, or \code{"growth"}).
Only required for \code{runMI()}.}

\item{\dots}{additional arguments to pass to \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or
\code{\link[lavaan:lavaanList]{lavaan::lavaanList()}}. See also \code{\link[lavaan:lavOptions]{lavaan::lavOptions()}}.
Note that \code{lavaanList} provides parallel computing options, as well as
a \code{FUN} argument so the user can extract custom output after the model
is fitted to each imputed data set (see \strong{Examples}).  TIP: If a
custom \code{FUN} is used \emph{and} \code{parallel = "snow"} is requested,
the user-supplied function should explicitly call \code{library} or use
\code{\link[base]{::}} for any functions not part of the base distribution.}

\item{m}{\code{integer}. Request the number of imputations. Ignored if \verb{data=} is
already a \code{list} of imputed data sets or an \code{OLDlavaan.mi} object.}

\item{miArgs}{Addition arguments for the multiple-imputation function
(\code{miPackage}). The arguments should be put in a list (see example
below). Ignored if \verb{data=} is already a \code{list} of imputed data
sets or an \code{OLDlavaan.mi} object.}

\item{miPackage}{Package to be used for imputation. Currently these
functions only support \code{"Amelia"} or \code{"mice"} for imputation.
Ignored if \code{data} is already a \code{list} of imputed data sets or an
\code{OLDlavaan.mi} object.}

\item{seed}{\code{integer}. Random number seed to be set before imputing the
data. Ignored if \code{data} is already a \code{list} of imputed data sets
or an \code{OLDlavaan.mi} object.}
}
\value{
A \linkS4class{OLDlavaan.mi} object
}
\description{
This function fits a lavaan model to a list of imputed data sets, and can
also implement multiple imputation for a single \code{data.frame} with
missing observations, using either the Amelia package or the mice package.
}
\examples{

## See the new lavaan.mi package

}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. New
York, NY: Guilford.

Rubin, D. B. (1987). \emph{Multiple imputation for nonresponse in surveys}.
New York, NY: Wiley.
}
\seealso{
\code{\link[=semTools-deprecated]{semTools-deprecated()}}

\code{\link[=semTools-deprecated]{semTools-deprecated()}}

\code{\link[=semTools-deprecated]{semTools-deprecated()}}

\code{\link[=semTools-deprecated]{semTools-deprecated()}}

\code{\link[=semTools-deprecated]{semTools-deprecated()}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})
}
\keyword{internal}
