% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearby_levels.R
\name{nearby_levels}
\alias{nearby_levels}
\title{LBCI Bounds of Nearby Levels of Confidence}
\usage{
nearby_levels(x, ciperc_levels = c(-0.025, 0.025), ciperc_range = c(0.6, 0.99))
}
\arguments{
\item{x}{The output of \code{\link[=semlbci]{semlbci()}}.}

\item{ciperc_levels}{A numeric vector of deviations
from the original level of confidence. The default
is \code{c(-.025, .025)}. Therefore, if the original level
is .95, the levels to be used is \code{c(-.025, .025) + .95}
or \code{c(.925, .975)}.}

\item{ciperc_range}{A numeric vector of two numbers,
which are the minimum and maximum levels of confidence
to be used, respectively. Default is \code{c(.60, .99)}.}
}
\value{
A \code{semlbci_list}-class object, which is
simply a named list of \code{semlbci}-class object,
names being the levels of confidence.
}
\description{
Find LBCIs with levels of confidence
different from those stored in a \code{semlbci}- class
object.
}
\details{
It receives a \code{semlbci}-class object, gets
the original level of confidence, generates one or
more levels of confidence different from this level
by certain amounts, and repeats the original call
to \code{\link[=semlbci]{semlbci()}} with these levels of confidence.
The results are returned as a list of class
\code{semlbci_list}, with the original\code{semlbci}-class
included.
}
\examples{

library(lavaan)
mod <-
"
m ~ x
y ~ m
"
fit_med <- sem(mod, simple_med, fixed.x = FALSE)
lbci_fit <- semlbci(fit_med)
lbci_fit_nb <- nearby_levels(lbci_fit,
                             ciperc_levels = c(-.050, .050))
names(lbci_fit_nb)
# Check the order of the confidence bounds.
# A confidence interval with a higher level of confidence
# should enclose a confidence interval with
# a lower level of confidence.
ci_order(lbci_fit_nb)

}
\seealso{
\code{\link[=semlbci]{semlbci()}}, \code{\link[=ci_order]{ci_order()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
