% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt.R
\name{lrt}
\alias{lrt}
\title{Fix a Free Parameter to Zero and Do an LR Test}
\usage{
lrt(
  fit,
  par_id,
  store_fit = FALSE,
  group = NULL,
  se_keep_bootstrap = FALSE,
  LRT_method = "default",
  scaled.shifted = TRUE,
  fallback_method = "satorra.2000"
)
}
\arguments{
\item{fit}{A \code{lavaan}-class object.}

\item{par_id}{It can be an integer.
or a string. If it is an integer,
it should be the row
number of the free parameter in the
parameter table of \code{fit} to be
fixed to zero. If it is a string,
it must be
a valid \code{lavaan} model syntax for
a parameter, or
the label of a labelled parameter.}

\item{store_fit}{Logical. If \code{TRUE},
\code{fit} will be stored in the output.
Default is \code{FALSE}.}

\item{group}{If a model syntax
is used in \code{par_id} and the model
is a multigroup model, this should
be either the group label or the
group number of the parameter.}

\item{se_keep_bootstrap}{Logical.
If \code{TRUE} and \code{fit} used
bootstrapping standard error
(with \code{se = "bootstrap"}), bootstrapping
will also be use in fitting the
restricted model. If \code{FALSE}, the
default, then \code{se} will be set
to \code{"standard"} if it is \code{"bootstrap"}
in \code{fit}, to speed up the computation.}

\item{LRT_method}{String. Passed to
the \code{method} argument of
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}. Default is
\code{"default"}, and let
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}} decide the
method based on \code{fit}.}

\item{scaled.shifted}{Logical.
Used when the method used in
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}} is
\code{"satorra.2000"}. Default is
\code{TRUE} and a scaled and shifted
test statistic is used, the same
default of \code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}.}

\item{fallback_method}{The default
method of \code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}},
\code{"satorra.bentler.2001"},
may sometimes fail. If failed,
this function will call
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}
again using \code{fallback_method}. which
is \code{"satorra.2000"} by default.}
}
\value{
A \code{lrt}-class object, which is a
list with the following elements:
\itemize{
\item \code{lrt}: The output of \code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}.
If there is an error message or
warning, it is set to \code{NA}.
\item \code{par_id}: The row number of the
designated free parameter.
\item \code{par_label}: The label of the
designated free parameter,
generated by \code{\link[lavaan:lav_partable]{lavaan::lav_partable_labels()}}.
\item \code{fit1}: The original \code{lavaan}
output, if \code{store_fit} is \code{TRUE}.
\code{NA} if \code{store_fit} is \code{FALSE},
the default.
\item \code{fix_to_zero}: The output of
\code{fit_to_zero()}.
\item \code{call}: The call to this function.
\item \code{lrt_status}: Integer. If 0, then
there is no error nor warning
in the likelihood ratio test and
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}} returns a
table (\code{data.frame}) of the test.
If -1, then something is wrong,
e.g., an error or warning occurred
when doing the likelihood ratio
test.
\item \code{lrt_msg}: If something went wrong
when doing the likelihood ratio
test, this is the error or warning
message when calling
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}.
If no error nor warning,
this is \code{NA}.
}
}
\description{
Fix the designated
free parameter to zero and do a
likelihood ratio test.
}
\details{
It fixes the designated
free parameter in a \code{lavaan} output,
refit the model, and do a likelihood
ratio test comparing this model with
the original model.

The model to be fixed is generated
by \code{\link[=fix_to_zero]{fix_to_zero()}}.

If the parameter to be fixed is
a variance, related covariance(s),
if any, will also be fixed to zero.

Users should usually call
\code{\link[=lrtp]{lrtp()}} directly instead of calling
this function. It is exported for
developers.
}
\examples{
library(lavaan)
data(data_sem16)
mod <-
"
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
"
fit <- sem(mod, data_sem16)
# Fix the factor covariance to zero
out <- lrt(fit, par_id = 15)
out$lrt
parameterEstimates(fit)[15, ]
parameterEstimates(out$fix_to_zero$fit0)[15, ]

# Can use model syntax for par_id

out <- lrt(fit, par_id = "f1 =~ x3")
out$lrt

}
\seealso{
\code{\link[=print.lrt]{print.lrt()}} for its
print-method, and \code{\link[=lrtp]{lrtp()}} for the
main function.
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
