% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.smartmode}
\alias{sensibo.pod.smartmode}
\title{Get the climate react settings for a given air conditioner (pod).}
\usage{
sensibo.pod.smartmode(pod, key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id.}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A list with the Climate React feature settings.
}
\description{
Get the climate react settings for a given air conditioner (pod).
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Get the climate react settings for the first pod
pod.smartsettings <- sensibo.pod.smartmode(pods.id[1])
}
}
