% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.state}
\alias{sensibo.pod.state}
\title{Get info from a specific state of a given air conditioner (pod).}
\usage{
sensibo.pod.state(pod, state, key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id.}

\item{state}{(character) State id to be retrieved.}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A list with the requested state details.
}
\description{
Get info from a specific state of a given air conditioner (pod).
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Getting the current state of the first pod
pod.current <- sensibo.pod.states(pods.id[1], n = 1) 

## Get more details of the given state (if available)
pod.state.details <- sensibo.pod.state(pods.id[1], pod.current[1])
}
}
