% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.sensmed.R
\name{ML}
\alias{ML}
\alias{ML.bb}
\alias{ML.bc}
\alias{ML.cb}
\alias{ML.cc}
\title{Functions for ML estimation of regression parameters for sensitivity analysis}
\usage{
ML.bb(model.expl, model.resp, Rho, progress = TRUE, ...)

ML.bc(model.expl, model.resp, Rho, progress = TRUE, ...)

ML.cb(model.expl, model.resp, Rho, progress = TRUE, ...)

ML.cc(model.expl, model.resp, Rho, progress = TRUE, ...)
}
\arguments{
\item{model.expl}{Fitted \code{\link{glm}} model object (probit or linear). If sensitivity analysis to mediator-outcome confounding the mediator model. Otherwise the exposure model.}

\item{model.resp}{Fitted \code{\link{glm}} model object (probit or linear). If sensitivity analysis to exposure-mediator confounding the mediator model. Otherwise the outcome model.}

\item{Rho}{The sensitivity parameter vector. If \code{type="my"} the correlation between the error terms in the mediator and outcome models. If \code{type="zm"} the correlation between the error terms in the exposure and mediator models. If \code{type="zy"} the correlation between the error terms in the exposure and outcome models.}

\item{progress}{Logical, indicating whether or not the progress (i.e. the \code{\link{proc.time}} for each \code{Rho}) of the optimization will be output}

\item{...}{Additional arguments to be passed on to the \code{maxLik} function. Can be used to set the \code{method} and \code{control} arguments of the \code{maxLik} function.}
}
\value{
A list with elements:
\item{coef}{A matrix with the estimated regression parameters for \code{model.resp} over the range of \code{Rho}. One column per value of \code{Rho}.}
\item{Rho}{The sensitivity parameter vector.}
\item{expl.coef}{A matrix with the estimated regression parameters for \code{model.expl} over the range of \code{Rho}. One column per value of \code{Rho}.}
\item{model.expl}{the original fitted \code{glm} object of \code{model.expl}.}
\item{model.resp}{the original fitted \code{glm} object of \code{model.resp}.}
\item{X.expl}{The model matrix (see \code{\link{model.matrix}}) of \code{model.expl}}
\item{X.resp}{The model matrix (see \code{\link{model.matrix}}) of \code{model.resp}}
\item{outc.resp}{The outcome variable of \code{model.resp}.}
\item{outc.expl}{The outcome variable of \code{model.expl}.}
\item{sigma.res.expl}{If \code{model.expl} is linear, a column matrix with the estimated residual standard deviation for \code{model.expl} over the range of \code{Rho}.}
\item{sigma.res.resp}{If \code{model.resp} is linear, a column matrix with the estimated residual standard deviation for \code{model.resp} over the range of \code{Rho}.}
\item{value}{The values of the -loglikelihood function for the best set of regression parameters from the optimization for each \code{Rho}.}
\item{sigmas}{A list with the covariance matrices for the model parameters in \code{model.expl} and \code{model.resp} for each \code{Rho}.}
\item{max.info}{Information about the maximization (whether or not the convergence was successful, \code{message}, \code{method} and number of iterations) for each \code{Rho}, see \code{\link[maxLik]{maxLik}} for more information.}
}
\description{
Functions for ML estimation of regression parameters for sensitivity analysis for different combinations of exposure, mediator and outcome models. The functions are named according to the convention \code{ML."model.expl type""model.resp type"} where \code{b}
stands for binary probit regression and \code{c} stands for linear regression. The optimization is performed using
\code{\link[maxLik]{maxLik}}. The functions are intended to be called through \code{\link{coefs.sensmed}}, not on their own.
}
\seealso{
\code{\link{coefs.sensmed}}, \code{\link[maxLik]{maxLik}}
}
\author{
Anita Lindmark
}
