% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.sensmed.R
\name{coefs.sensmed}
\alias{coefs.sensmed}
\title{ML estimation of regression parameters for calculation of direct and indirect effects under unobserved confounding}
\usage{
coefs.sensmed(model.expl, model.resp, Rho, progress = TRUE, ...)
}
\arguments{
\item{model.expl}{Fitted \code{\link{glm}} model object. If sensitivity analysis to mediator-outcome confounding the mediator model. Otherwise the exposure model.}

\item{model.resp}{Fitted \code{\link{glm}} model object. If sensitivity analysis to exposure-mediator confounding the mediator model. Otherwise the outcome model.}

\item{Rho}{The sensitivity parameter vector. If \code{type="my"} the correlation between the error terms in the mediator and outcome models. If \code{type="zm"} the correlation between the error terms in the exposure and mediator models. If \code{type="zy"} the correlation between the error terms in the exposure and outcome models.}

\item{progress}{Logical, indicating whether or not the progress (i.e. the \code{\link{proc.time}} for each \code{Rho}) of the optimization will be output}

\item{...}{Additional arguments to be passed on to the \code{maxLik} function. Can be used to set the \code{method} and \code{control} arguments of the \code{maxLik} function.}
}
\value{
\code{coefs.sensmed} returns a list with elements:
\item{call}{The matched call}
\item{coef}{A matrix with the estimated regression parameters for \code{model.resp} over the range of \code{Rho}. One column per value of \code{Rho}.}
\item{sigma.res.resp}{If \code{model.resp} is a linear regression model, the estimated standard deviation of the error term for each \code{Rho}.}
\item{sigma.res.expl}{If \code{model.expl} is a linear regression model, the estimated standard deviation of the error term for each \code{Rho}.}
\item{Rho}{The sensitivity parameter vector.}
\item{expl.coef}{A matrix with the estimated regression parameters for \code{model.expl} over the range of \code{Rho}. One column per value of \code{Rho}.}
\item{model.expl}{the original fitted \code{glm} object of \code{model.expl}.}
\item{model.resp}{the original fitted \code{glm} object of \code{model.resp}.}
\item{X.expl}{The model matrix (see \code{\link{model.matrix}}) of \code{model.expl}}
\item{X.resp}{The model matrix (see \code{\link{model.matrix}}) of \code{model.resp}}
\item{outc.resp}{The outcome variable of \code{model.resp}.}
\item{outc.expl}{The outcome variable of \code{model.expl}.}
\item{sigmas}{A list with the estimated covariance matrices for the regression parameters of \code{model.resp} and \code{model.expl} over \code{Rho}.}
\item{max.info}{Information about the maximization (whether or not the convergence was successful, \code{message}, \code{method} and number of iterations) for each \code{Rho}, see \code{\link[maxLik]{maxLik}} for more information.}
\item{value}{The values of the loglikelihood function for the best set of regression parameters from the optimization for each \code{Rho}, see \code{\link[maxLik]{maxLik}}.}
}
\description{
This function gives ML estimates of the regression parameters used to calculate mediation effects and perform sensitivity analysis. The optimization is
performed using \code{\link[maxLik]{maxLik}}, see Details for more information. Called by \code{\link{sensmediation}}.
}
\details{
The maximization of the log-likelihood is performed using \code{\link[maxLik]{maxLik}}, the default is to use the Newton-Raphson method and an analytic gradient and Hessian.
}
\examples{

\dontrun{
# Example with data from Riksstroke (the Swedish stroke register)

data(RSdata)

# Probit mediator and outcome models:
m.model <- glm(lowered.consc ~ AF + age.cat + sex, data = RSdata,
   family = binomial(link = 'probit'))
o.model <- glm(cf.3mo ~ AF + lowered.consc + age.cat + sex, data = RSdata,
   family = binomial(link = 'probit'))

# Estimation of regression coefficients under different values of Rho
# Rho = correlation between error terms in mediator and outcome model:
coefs.MY <- coefs.sensmed(model.expl = m.model, model.resp = o.model, Rho = seq(0, 0.5, 0.1))
# Outcome model regression coefficients:
coefs.MY$coef
}

}
\references{
Henningsen, A., Toomet, O. (2011). maxLik: A Package for Maximum Likelihood Estimation in R, \emph{Computational Statistics}, \bold{26(3)}, pp. 443--458.
}
\seealso{
\code{\link{sensmediation}}
}
\author{
Anita Lindmark
}
