% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_measures_xyz.R
\name{measures_update}
\alias{measures_update}
\title{Update sentiment measures}
\usage{
measures_update(sento_measures, sento_corpus, lexicons)
}
\arguments{
\item{sento_measures}{\code{sento_measures} object created with \code{\link{sento_measures}}}

\item{sento_corpus}{a \code{sento_corpus} object created with \code{\link{sento_corpus}}.}

\item{lexicons}{a \code{sento_lexicons} object created with \code{\link{sento_lexicons}}.}
}
\value{
An updated \code{sento_measures} object.
}
\description{
Updates a \code{sento_measures} object based on a new \code{sento_corpus} provided.
Sentiment for the unseen corpus texts calculated and aggregated applying the control variables
from the input \code{sento_measures} object.
}
\examples{
data("usnews", package = "sentometrics")

corpus1 <- sento_corpus(usnews[1:500, ])
corpus2 <- sento_corpus(usnews[400:2000, ])

ctr <- ctr_agg(howTime = "linear", by = "year", lag = 3)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")],
                    list_valence_shifters[["en"]])
sento_measures <- sento_measures(corpus1, l, ctr)
sento_measuresNew <- measures_update(sento_measures, corpus2, l)

}
\seealso{
\code{\link{sento_measures}}, \code{\link{compute_sentiment}}
}
\author{
Jeroen Van Pelt, Samuel Borms, Andres Algaba
}
