% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_min_max.R
\name{local_min_max}
\alias{local_min_max}
\title{Local minimum and maximum of a real-valued continuous function over an open interval}
\usage{
local_min_max(f, f1der, f2der, what = c("min", "max"), x0, D)
}
\arguments{
\item{f}{function expression}

\item{f1der}{function expression of first derivative of \code{f}}

\item{f2der}{function expression of second derivative of \code{f}}

\item{what}{character. What to look for? A local \code{min} or a \code{max}?}

\item{x0}{numeric givin global minimum or maximum of \code{f} over the
the interval \code{D}.}

\item{D}{numeric vector specifying the interval over which \code{f}
is optimized}
}
\value{
A list containing:
\itemize{
   \item \code{x_opt} numeric giving the critical point where the local min or max
       is achieved. When local min or max cannot be determined, this function returns \code{NA}.
   \item \code{locals} numeric vector giving all critical points satisfying second derivative criteria.
   \item \code{crtPts} a list with 2 entries:
   \itemize{
       \item \code{x_d1} numeric vector with local critical points over \code{[D[1],x-1)}
       \item \code{x_d2} numeric vector with local critical points over \code{(x0+1,D[length(D)]]}
   }
   \item \code{type} character, what was found? A \code{min} or a \code{max}?
}
}
\description{
Gets local minimum and maximum of a given function expression
on an interval using basic calculus criteria
}
\details{
This function looks for critical values
over the interval \code{[D[1],x0-1)} \eqn{\cup} \code{(x0+1, D[length(D)]]}.
}
\seealso{
\code{\link{global_min_max}}, \code{\link{phenopar}}
}
