% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqtest.prop.R
\name{seqtest.prop}
\alias{seqtest.prop}
\title{Sequential triangular test for the proportion}
\usage{
seqtest.prop(x, y = NULL, pi = NULL, alternative = c("two.sided", "less", "greater"),
             delta, alpha = 0.05, beta = 0.1, output = TRUE, plot = FALSE)
}
\arguments{
\item{x}{initial data for group x, at least one entry.}

\item{y}{initial data for group y, at least one entry for a two-sample test.}

\item{pi}{a number indicating the true value of the probability of success in group x, \eqn{\pi}.0.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "less" or "greater".}

\item{delta}{minimum difference to be detected, \eqn{\delta}.}

\item{alpha}{type-I-risk, \eqn{\alpha}.}

\item{beta}{type-II-risk, \eqn{\beta}.}

\item{output}{logical: if \code{TRUE}, output is shown.}

\item{plot}{logical: if \code{TRUE}, a plot is generated.}
}
\value{
Returns an object of class \code{seqtest}, to be used for later update steps. The object has
following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{type}      \tab type of the test (i.e., proportion) \cr
  \code{spec}      \tab specification of function arguments \cr
  \code{tri}       \tab specification of the triangular \cr
  \code{dat}       \tab data \cr
  \code{res}       \tab list with results \cr
}
}
\description{
This function performs the sequential triangular test for the proportion
in one- or two-samples
}
\details{
For the one-sample test, arguments \code{x}, \code{pi}, and \code{delta} has to be specified
(i.e., argument \code{y} must not be specified).
For the two-sample test, arguments \code{x}, \code{y}, \code{pi}, and \code{delta} has to be specified

In order to specify a one-sided test, argument \code{alternative} has to be used (i.e., two-sided tests are conducted by default).
For the one-sample test, \code{alternative = "less"} specifies the null hypothesis, H0: \eqn{\pi} >= \eqn{\pi}.0
and the alternative hypothesis, H1: \eqn{\pi} < \eqn{\pi}.0; \code{alternative = "greater"} specifies the
null hypothesis, H0: \eqn{\pi} <= \eqn{\pi}.0 and the alternative hypothesis, H1: \eqn{\pi} > \eqn{\pi}.0.
For the two-sample test \code{alternative = "less"} specifies the null hypothesis, H0: \eqn{\pi}.1 >= \eqn{\pi}.2
and the alternative hypothesis, H1: \eqn{\pi}.1 < \eqn{\pi}.2; \code{alternative = "greater"} specifies
the null hypothesis, H0: \eqn{\pi}.1 <= \eqn{\pi}.2 and the alternative hypothesis, H1: \eqn{\pi}.1 > \eqn{\pi}.2.

The main characteristic of the sequential triangular test is that there is no fixed sample size given
in advance. That is, for the most recent sampling point, one has to decide whether
sampling has to be continued or either the null- or the alternative hypothesis can be
accepted given specified precision requirements (i.e. type-I-risk, type-II-risk and an effect size).
The (cumulative) test statistic \code{Z.m} on a Cartesian coordinate system produces a "sequential path"
on a continuation area as a triangle. As long as the statistic remains within that triangle,
additional data have to be sampled. If the path touches or exceeds the borderlines of the triangle,
sampling is completed. Depending on the particular borderline, the null-hypothesis is either
accepted or rejected.
}
\examples{

#--------------------------------------
# Two-sided one-sample test
# H0: pi = 0.5, H1: pi != 0.5
# alpha = 0.05, beta = 0.2, delta = 0.2

seq.obj <- seqtest.prop(c(1, 1, 0, 1), pi = 0.5, delta = 0.2,
                        alpha = 0.05, beta = 0.2, plot = TRUE)

seq.obj <- update(seq.obj, x = c(1, 1, 1, 1, 1, 0, 1, 1, 1))
seq.obj <- update(seq.obj, x = c(0, 1, 1, 1))
seq.obj <- update(seq.obj, x = c(1, 1))

#--------------------------------------
# One-sided one-sample test
# H0: pi <= 0.5, H1: pi > 0.5
# alpha = 0.05, beta = 0.2, delta = 0.2

seq.obj <- seqtest.prop(c(1, 1, 0, 1), pi = 0.5,
                        alternative = "greater", delta = 0.2,
                        alpha = 0.05, beta = 0.2, plot = TRUE)

seq.obj <- update(seq.obj, x = c(1, 1, 1, 1, 1, 0, 1, 1, 1))
seq.obj <- update(seq.obj, x = c(0, 1, 1, 1))

#--------------------------------------
# Two-sided two-sample test
# H0: pi.1 = pi.2 = 0.5, H1: pi.1 != pi.2
# alpha = 0.01, beta = 0.1, delta = 0.2

seq.obj <- seqtest.prop(1, 0, pi = 0.5, delta = 0.2,
                        alpha = 0.01, beta = 0.1, plot = TRUE)

seq.obj <- update(seq.obj, x = c(1, 1, 1, 0), y = c(0, 0, 1, 0))
seq.obj <- update(seq.obj, x = c(0, 1, 1, 1), y = c(0, 0, 0, 0))
seq.obj <- update(seq.obj, x = c(1, 0, 1, 1), y = c(0, 0, 0, 1))
seq.obj <- update(seq.obj, x = c(1, 1, 1, 1), y = c(0, 0, 0, 0))
seq.obj <- update(seq.obj, x = c(0, 1, 0, 1))
seq.obj <- update(seq.obj, y = c(0, 0, 0, 1))
seq.obj <- update(seq.obj, x = c(1, 1, 1, 1))

#--------------------------------------
# One-sided two-sample test
# H0: pi.1 <=  pi.1 = 0.5, H1: pi.1 > pi.2
# alpha = 0.01, beta = 0.1, delta = 0.2

seq.obj <- seqtest.prop(1, 0, pi = 0.5, delta = 0.2,
                        alternative = "greater",
                        alpha = 0.01, beta = 0.1, plot = TRUE)

seq.obj <- update(seq.obj, x = c(1, 1, 1, 0), y = c(0, 0, 1, 0))
seq.obj <- update(seq.obj, x = c(0, 1, 1, 1), y = c(0, 0, 0, 0))
seq.obj <- update(seq.obj, x = c(1, 0, 1, 1), y = c(0, 0, 0, 1))
seq.obj <- update(seq.obj, x = c(1, 1, 1), y = c(0, 0))
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
\references{
Rasch, D., Pilz, J., Verdooren, L. R., & Gebhardt, G. (2011).
\emph{Optimal experimental design with R}. Boca Raton: Chapman & Hall/CRC.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{update.seqtest}}, \code{\link{seqtest.mean}}, \code{\link{seqtest.cor}},
\code{\link{print.seqtest}}, \code{\link{plot.seqtest}}, \code{\link{descript}}
}

