% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bayes}
\alias{bayes}
\title{Bayesian method}
\usage{
bayes(s, n, alpha, MonteCarlo, beta.a, beta.b, ...)
}
\arguments{
\item{s}{Vector of successes.}

\item{n}{Vector of sample sizes.}

\item{alpha}{The significance level; to calculate a 100(1-\eqn{\alpha})\% lower confidence bound.}

\item{MonteCarlo}{Number of samples to draw from the posterior distribution for the Monte Carlo estimate.}

\item{beta.a}{Shape1 parameter for the Beta prior distribution.}

\item{beta.b}{Shape2 parameter for the Beta prior distribution.}

\item{...}{Additional arguments to be ignored.}
}
\value{
The 100(1-\eqn{\alpha})\% lower confidence bound.
}
\description{
Calculate a binomial series lower confidence bound using Bayes' method with a Beta prior distribution.
}
\examples{
bayes(s=c(35, 97, 59), n=c(35, 100, 60), alpha=.10, MonteCarlo=1000, beta.a=1, beta.b=1)
}
