% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seromodel.R
\name{plot_seromodel}
\alias{plot_seromodel}
\title{Visualise results of the provided model}
\usage{
plot_seromodel(
  seromodel,
  serosurvey,
  alpha = 0.05,
  bin_serosurvey = FALSE,
  bin_step = 5,
  foi_df = NULL,
  foi_max = NULL,
  loo_estimate_digits = 1,
  central_estimate_digits = 2,
  seroreversion_digits = 2,
  rhat_digits = 2,
  size_text = 11,
  plot_constant = FALSE,
  x_axis = NA
)
}
\arguments{
\item{seromodel}{stan_fit object obtained from sampling a model
with \link{fit_seromodel}}

\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{alpha}{1 - alpha indicates the credibility level to be used}

\item{bin_serosurvey}{If \code{TRUE}, \code{serodata} is binned by means of
\code{prepare_bin_serosurvey}.
Otherwise, age groups are kept as originally input.}

\item{bin_step}{Integer specifying the age groups bin size to be used when
\code{bin_serosurvey} is set to \code{TRUE}.}

\item{foi_df}{Dataframe with columns
\describe{
\item{\code{year}/\code{age}}{Year/Age (depending on the model)}
\item{\code{foi}}{Force-of-infection values by year/age}
}}

\item{foi_max}{Max FoI value for plotting}

\item{loo_estimate_digits}{Number of loo estimate digits}

\item{central_estimate_digits}{Number of central estimate digits}

\item{seroreversion_digits}{Number of seroreversion rate digits}

\item{rhat_digits}{Number of rhat estimate digits}

\item{size_text}{Size of text for plotting (\code{base_size} in
\link[ggplot2:ggtheme]{ggplot2})}

\item{plot_constant}{boolean specifying whether to plot single
Force-of-Infection estimate and its corresponding rhat value instead
of showing this information in the summary.
Only relevant when \code{seromodel@model_name == "constant"})}

\item{x_axis}{either \code{"time"} or \code{"age"}. Specifies time axis values
label for constant model additional plots. Only relevant when
and \code{seromodel@model_name == "constant"}}
}
\value{
seromodel summary plot
}
\description{
Visualise results of the provided model
}
\examples{
\donttest{
data(veev2012)
seromodel <- fit_seromodel(veev2012, iter = 100)
plot_seromodel(seromodel, veev2012)
}
}
