% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric.R
\name{lp_model}
\alias{lp_model}
\title{A local polynomial model.}
\usage{
lp_model(data, kern = "tcub", nn = 0, h = 0, deg = 2)
}
\arguments{
\item{data}{the input data frame, must either have `age`, `pos`, `tot` columns (for aggregated data) OR `age`, `status` for (linelisting data)}

\item{kern}{Weight function, default = "tcub".
Other choices are "rect", "trwt", "tria", "epan", "bisq" and "gauss".
Choices may be restricted when derivatives are required;
e.g. for confidence bands and some bandwidth selectors.}

\item{nn}{Nearest neighbor component of the smoothing parameter.
Default value is 0.7, unless either h is provided, in which case the default is 0.}

\item{h}{The constant component of the smoothing parameter. Default: 0.}

\item{deg}{Degree of polynomial to use. Default: 2.}
}
\value{
a list of class lp_model with 6 items
  \item{datatype}{type of datatype used for model fitting (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{pi}{fitted locfit object for pi}
  \item{eta}{fitted locfit object for eta}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Refers to section 7.1. and 7.2.
}
\examples{
df <- mumps_uk_1986_1987
model <- lp_model(
  df,
  nn=0.7, kern="tcub"
  )
plot(model)

}
\seealso{
[locfit::locfit()] for more information on the fitted locfit object
}
