% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_arrow.R
\name{st_read_parquet}
\alias{st_read_parquet}
\title{Read a Parquet file to \code{sf} object}
\usage{
st_read_parquet(dsn, col_select = NULL, props = NULL, ...)
}
\arguments{
\item{dsn}{character file path to a data source}

\item{col_select}{A character vector of column names to keep. Default is
\code{NULL} which returns all columns}

\item{props}{Now deprecated in \code{\link[arrow]{read_parquet}}.}

\item{...}{additional parameters to pass to
\code{\link[arrow]{ParquetFileReader}}}
}
\value{
object of class \code{\link[sf]{sf}}
}
\description{
Read a Parquet file. Uses standard metadata information to
identify geometry columns and coordinate reference system information.
}
\details{
Reference for the metadata used:
\url{https://github.com/geopandas/geo-arrow-spec}. These are standard with
the Python \code{GeoPandas} library.
}
\examples{
# load Natural Earth low-res dataset.
# Created in Python with GeoPandas.to_parquet()
path <- system.file("extdata", package = "sfarrow")

world <- st_read_parquet(file.path(path, "world.parquet"))

world
plot(sf::st_geometry(world))

}
\seealso{
\code{\link[arrow]{read_parquet}}, \code{\link[sf]{st_read}}
}
