% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilbert_3d.R
\name{hilbert_3d}
\alias{hilbert_3d}
\title{Three dimensional Hilbert curve}
\usage{
hilbert_3d(level = 2L)
}
\arguments{
\item{level}{The level of the curve.}
}
\value{
A three-column matrix of coordinates of points on the 3D Hilbert curve.
}
\description{
Three dimensional Hilbert curve
}
\details{
There are many forms of 3D Hilbert curve. Here we only implement one specific form.
}
\examples{
pos = hilbert_3d(2)
if(require(rgl) && interactive()) {
    plot3d(pos, type = "l", lwd = 4, col = 2)
}
}
\seealso{
Michael Bader. Space-Filling Curves: An Introduction with Applications in Scientific Computing, Springer Science & Business Media, 2012. \doi{10.1007/978-3-642-31046-1}.
}
