% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_base.R
\name{sfc_base}
\alias{sfc_base}
\title{Constructor of the sfc_base class}
\usage{
sfc_base(
  letter,
  in_direction,
  out_direction,
  grob = NULL,
  primary = TRUE,
  open = TRUE
)
}
\arguments{
\item{letter}{A single letter to represent the base pattern.}

\item{in_direction}{The direction of the segment that enters the point, measured in the polar coordinate system, in degrees.}

\item{out_direction}{The direction of the segment that leaves the point, measured in the polar coordinate system, in degrees.}

\item{grob}{A \code{\link[grid:grid.grob]{grid::grob()}} object of this base pattern. If it is not set, it is generated according to \code{in_direction} and \code{out_direction}.}

\item{primary}{Currently, going forward, turning left and turning right can be set as primary base patterns because other high-level patterns
can be built from them.}

\item{open}{Can the base pattern be connected to other base patterns?}
}
\value{
An \code{sfc_base} object.
}
\description{
Constructor of the sfc_base class
}
\details{
The "base pattern" is designed not only for single point but also for combination of points that form a "base curve". However,
currently, it is fixed to the single point base pattern.

Currently, this package supports 2x2 and 3x3 space-filling curves that fills grids in 2D space constructed by the Gaussian integers.
And when the curve expands, we only allow the segments to go forward, backward, left and right. Thus there are the following base patterns
pre-defined in this package:
\itemize{
\item \code{\link{BASE_I}}/\code{\link{BASE_J}}: go forward.
\item \code{\link{BASE_R}}: turn right.
\item \code{\link{BASE_L}}: turn left.
\item \code{\link{BASE_U}}: go backward.
\item \code{\link{BASE_B}}: leave the start point where the start point is closed.
\item \code{\link{BASE_D}}: leave the start point where the start point is closed.
\item \code{\link{BASE_P}}: return to the end point where the end point is closed.
\item \code{\link{BASE_Q}}: return to the end point where the end point is closed.
\item \code{BASE_C}: self-closed.
}

The base pattern determines the final form of the curve.
}
\examples{
BASE_I
}
