% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi0_model.R
\name{pi0_model}
\alias{pi0_model}
\title{Formulates the model for the proportion of null tests}
\usage{
pi0_model(z, indep_snps = NULL, basis.df = 3, knots = NULL)
}
\arguments{
\item{z}{\code{matrix}: informative variables that impact the power of the
p-values (rows are tests and columns are different informative variables).
Currently, there must be no missing values.}

\item{indep_snps}{\code{vector} Boolean indicating the set of independent SNPs}

\item{basis.df}{\code{integer}: the degrees of freedom for the natural cubic spline on each variable.
Default is 3 at equally space intervals.}

\item{knots}{\code{vector}: Specify the location of the knots in natural cubic spline. Note
that the knots are specified using quantiles by default. Default is NULL and uses basis.df at equally space intervals.}
}
\value{
A list with the following entries:
\enumerate{
 \item fmod: model formula
 \item zt: matrix of rank-transformed informative variables
 }
}
\description{
\code{pi0_model} helps generate the model for the proportion of truly null tests.
 For more details, refer to the vignette.
}
\details{
We note that this function is specifically designed for informative p-values and other
complex models should be created outside this function.
}
\examples{
data(bmi)

p <- sumstats$bmi
z <- as.matrix(sumstats[, -1])

# For p-values, you want to specify the lower quantiles
fmod <- pi0_model(z, knots = c(0.005, 0.01, 0.025, 0.05, 0.1))

}
\seealso{
\code{\link{sffdr}}
}
\author{
Andrew Bass
}
\keyword{pi0_model}
