\name{pkgDesc}
\title{Version of packageDescription() as Simple Vector}
\alias{pkgDesc}
\alias{pkgBuilt}
\description{
  a simple \dQuote{version}, or wrapper for
  \code{\link{packageDescription}()}, returning a named character vector,
  including \code{"file"}, and still has a useful \code{\link{print}()}
  method.
}
\usage{
pkgDesc (pkg, lib.loc = NULL, fields = NULL, onlyLT = 99, ...)
pkgBuilt(pkg, lib.loc = NULL, ...)
}
\arguments{
  \item{pkg}{a \code{\link{character}} string, name of an installed \R package.}
  \item{lib.loc}{library location to find the package in; the default
    \code{NULL} uses the full \code{\link{.libPaths}()}.}
  \item{fields}{a character vector (or \code{NULL}) specifying fields to be returned.}
  \item{onlyLT}{positive integer specifying an upper limit on the number of
    characters of fields to be returned and printed.}
  \item{...}{further optional arguments passed to \code{\link{packageDescription}()}.}
}
\value{
  a named \code{\link{character}} vector, with \code{\link{names}}, the
  \emph{fields}, identical to the names of the \code{\link{list}} returned
  by \code{\link{packageDescription}}, plus its \code{"file"} attribute.
  Additionally the resulting vector is of class \code{"Dlist"} which
  activates a useful \code{\link{print}()} method.
}
\author{Martin Maechler, Jan. 2021}
\note{The \code{file} is always returned; not the least that the author
  wants to see it quite often as his \code{\link{.libPaths}()} is
  non-trivial and typically longer than 4 entries.

  I started to hate screen fulls of Authors and/or Description; when I
  wanted quite basic info, hence \code{onlyLT} with a reasonable default.
}
\seealso{
  \code{\link{packageDescription}},
  \code{\link{.libPaths}}.
}
\examples{
str(pd <- pkgDesc("sfsmisc"))
pd[c("Date","Packaged", "Built","file")]

## see the effects of  `onlyLT` :
str(p1 <- pkgDesc("sfsmisc", onlyLT = Inf)) # .. [1:25] ..
str(pD  <-pkgDesc("sfsmisc"              )) # .. [1:21] ..
str(p50 <-pkgDesc("sfsmisc", onlyLT = 50 )) # .. [1:18] ..
t(sapply(list(full = p1, def. = pD, p50 = p50),
         function(pd) {n <- nchar(pd); c(summary(n)[-1], SUM = sum(n))}))

pkgBuilt("sfsmisc")

## Show "Built" (and "file") for all packages whose namespaces are loaded:
lNs <- loadedNamespaces()
mlNs <- sapply(lNs, pkgBuilt)
t(mlNs) # typically prints nicely

pkgs <- c("grid", "lattice", "MASS", "Matrix", "nlme", "lme4", "sfsmisc")
pkgs <- c("foobar", "barbar", pkgs, "kitty") # + names that typically don't exist
pkgsOk <- basename(find.package(pkgs, quiet=TRUE))
mpkg <- sapply(pkgsOk, pkgBuilt)
stopifnot(is.matrix(mpkg), nrow(mpkg) == 2)
mpkg["Built",]
}
