% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{set.control.init}
\alias{set.control.init}
\title{Check and set the initialization parameters for a GMF model}
\usage{
set.control.init(
  method = c("ols", "glm", "random", "values"),
  type = c("deviance", "pearson", "working", "link"),
  values = list(),
  niter = 5,
  normalize = TRUE,
  verbose = FALSE,
  parallel = FALSE,
  nthreads = 1
)
}
\arguments{
\item{method}{initialization method (see \code{\link{sgdgmf.init}} for more details upon the initialization methods used)}

\item{type}{residual type to be decomposed (see \code{\link{sgdgmf.init}} for more details upon the residuals used)}

\item{values}{list of custom initialization parameters fixed by the user}

\item{niter}{number if refinement iterations in the \code{"svd"} method}

\item{normalize}{if \code{TRUE}, normalize \code{U} and \code{V} to orthogonal \code{U} and lower triangular \code{V}}

\item{verbose}{if \code{TRUE}, print the initialization state}

\item{parallel}{if \code{TRUE}, use parallel computing for the \code{"glm"} method}

\item{nthreads}{number of cores to be used in the \code{"glm"} method}
}
\value{
A \code{list} of control parameters for the initialization
}
\description{
Check if the input initialization parameters are allowed and set them to default
values if they are not. Returns a list of well-defined options which specify how
to initialize a GMF model. See \code{\link{sgdgmf.init}} for more details upon the methods used for initialisation.
}
\examples{
library(sgdGMF)

# Empty call
set.control.init()

# Parametrized call
set.control.init(method = "glm", type = "deviance", niter = 10)

}
\seealso{
\code{\link{set.control.alg}}, \code{\link{set.control.cv}}, \code{\link{sgdgmf.init}}
}
