% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplingDistCalculation.R
\name{samplingDistCalculation}
\alias{samplingDistCalculation}
\title{samplingDistCalculation}
\usage{
samplingDistCalculation(sampleProb, y, x, clusterID, waves, beta, beta0, phi,
  alpha, offset, meanLinkInv, varianceLink, corstr, mu.eta)
}
\arguments{
\item{sampleProb}{A user provided value for the probability associated
with each observation. \code{sampleProb} can be provided as 1) a vector of
fixed values of length equal to the resposne vector y, 2) a function
that takes in a list of values (full list of values given in details)
and returns a vector of length equal to the response vector y, or 3) the
default value of \code{NULL}, which results in a uniform distribution}

\item{y}{The vector of the response values provided to the original
stagewise function}

\item{x}{The covariate matrix provided to the original stagewise function}

\item{clusterID}{The vector of cluster ID numbers provided to the original
stagewise function}

\item{waves}{The waves parameter identifying the order of observations
within the clusters that is provided to the original stagewise function}

\item{beta}{The vector of the current estimates of the coefficients}

\item{beta0}{The current estimate of the intercept}

\item{phi}{Current estimate of the scale parameter}

\item{alpha}{Current estimate of the parameter affecting the within
cluster correlation}

\item{offset}{offset in the linear predictor provided to the original
stagewise function}

\item{meanLinkInv}{The link inverse function from the \code{family}
object provided to the original stagewise function indicating what family
of mean and variance structure is assumed}

\item{varianceLink}{The variance link function from the \code{family}
object provided to the original stagewise function indicating what family
of mean and variance structure is assumed}

\item{corstr}{The structure of the working correlation matrix that was
provided to the original stagewise function}

\item{mu.eta}{Derivative function of mu, the conditional mean of the
response, with respect to eta, the linear predictor, from the \code{family}
object provided to the original stagewise function indicating what family
of mean and variance structure is assumed}
}
\value{
The sampling distribution probabilities to be used for the sub
sampling. distribution is provided as a vector with length equal to the
number of clusters.
}
\description{
Internal function to set up subsampling distribution
to execute the stochastic version of a stagewise approach.
The subsampling is coducted at the cluster level, not the
individual observation level. Sampling probabilities are first
calculated or provided for each observation individually, and
then the sampling probability for each cluster is taken to be
the average probability across all observations in the cluster.
}
\note{
Internal function.

The function provided to \code{sampleProb} (through the
\code{sgee.control} function) needs to calculate
probabilities for each observation in the response vector \code{y}.
How these calculations are done is up to the user and the following
values are provided to the \code{sampleProb} function as a list called
\code{values}: \code{y}, \code{x}, \code{clusterID}, \code{waves},
\code{beta}, \code{beta0}, \code{phi}, \code{alpha}, \code{offset},
\code{meanLinkInv}, \code{varianceLink}, \code{corstr}, \code{mu.eta}.
additionally, all of the values produced by \code{sampleProb} need to be
non-negative.
}
\author{
Gregory Vaughan
}
\keyword{internal}
