% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrl_gg.R
\name{mrl_gg}
\alias{mrl_gg}
\title{Mean Residual Lifetime Function for a Generalized Gamma Distribution}
\usage{
mrl_gg(x = 1, mu = 0, sigma = 1, lambda = 1)
}
\arguments{
\item{x}{numeric, represent a vector of positive values. Default value is 1.}

\item{mu}{numeric, represents the location parameter of a generalized gamma distribution. Default value is 0.}

\item{sigma}{numeric, represents the scale parameter of a generalized gamma distribution. Default value is 1.}

\item{lambda}{numeric, represents the shape parameter of a generalized gamma distribution. Default value is 1.}
}
\value{
A numeric value of the mean residual lifetime of a generalized gamma distribution.
}
\description{
\code{mrl_gg} is used to obtain the value of the mean residual lifetime function of a generalized gamma distribution at a positive value.
}
\examples{
mrl_gg(x=0,mu=0,sigma=2,lambda=1) # Extreme value type I distribution, maximum case.
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph.D. thesis. Sao Paulo University.

Jerald F. Lawless (2003). Statistical Models and Methods for Lifetime Data. Second Edition. John-Wiley & Sons
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
