% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdate.R, R/jdatetime.R
\name{shide-arithmetic}
\alias{shide-arithmetic}
\alias{vec_arith.jdate}
\alias{vec_arith.jdatetime}
\title{Arithmetic operations for \code{jdate} and \code{jdatetime}}
\usage{
\method{vec_arith}{jdate}(op, x, y, ...)

\method{vec_arith}{jdatetime}(op, x, y, ...)
}
\arguments{
\item{op}{An arithmetic operator as a string.}

\item{x, y}{A pair of vectors.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
The binary operator result of \code{x} and \code{y}. See
details for more information on operator behaviors.
}
\description{
Arithmetic operations for \code{jdate} and \code{jdatetime}
}
\details{
Supported operations:
\itemize{
\item Difference between two \code{jdate} objects results a \code{difftime} object with \code{units = "days"}.
\item Difference between two \code{jdatetime} objects results a \code{difftime} object with \code{units = "seconds"}.
\item A numeric vector can be added to or subtracted from a \code{jdate} or \code{jdatetime}.
\item A \code{difftime} vector can be added to or subtracted from a \code{jdate} only if it has
resolution bigger than "days".
\item A \code{difftime} vector can be added to or subtracted from a \code{jdatetime}.
\item A \code{jdate} object can be subtracted from a \code{jdatetime} and vice versa.
}
}
\examples{
jdatetime_now() - jdate_now()
jdate_now() - as.difftime(1, units ="weeks" ) - as.difftime(1, units = "days")
}
