% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{Checkbox}
\alias{Checkbox}
\alias{Checkbox.shinyInput}
\title{Checkbox}
\usage{
Checkbox(...)

Checkbox.shinyInput(inputId, ..., value = defaultValue)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{value}{Initial value.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/checkbox}
}
\examples{
library(shiny.blueprint)
library(shiny)

setInput <- function(inputId, accessor = NULL) {
  JS(paste0("x => Shiny.setInputValue('", inputId, "', x", accessor, ")"))
}

ui <- function(id) {
  ns <- NS(id)
  tagList(
    Checkbox(
      onChange = setInput(ns("apples"), ".target.checked"),
      defaultChecked = TRUE,
      label = "Apples"
    ),
    Checkbox.shinyInput(
      inputId = ns("bananas"),
      value = TRUE,
      label = "Bananas"
    ),
    textOutput(ns("applesEnabled")),
    textOutput(ns("bananasEnabled"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$applesEnabled <- renderText(paste("Apples:", deparse(input$apples)))
    output$bananasEnabled <- renderText(paste("Bananas:", deparse(input$bananas)))
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
