% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeInput.R
\name{removeInput}
\alias{removeInput}
\title{Remove Input from Shiny Session}
\usage{
removeInput(
  id,
  selector = paste0("#", id),
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{Input value name}

\item{selector}{The HTML selector to remove the UI for. By default it is the
tag where the ID matches the input, but might need to be adjusted for
different inputs.}

\item{session}{The Shiny session to remove the input from}
}
\value{
An invisible `TRUE` value confirming that the input has been removed.
}
\description{
The removal of the named input in a shiny session.
}
\details{
If the input is a standard shiny input e.g. `numericInput`, then to
remove the label as well as the input, set the selector to be
`paste0(":has(> #", id, ")")`
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shiny.destroy)

ui <- fluidPage(
  numericInput("number", "Select number:", 5, 1, 10),
  p("Selected number:", textOutput("number_out", inline = TRUE)),
  actionButton("delete", "Remove input")
)

server <- function(input, output, session) {
  output$number_out <- renderText(input$number \%||\% "input unavailable")

  observeEvent(
    input$delete,
    removeInput("number", selector = ":has(> #number)")
   )
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
