% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdown.R
\name{update_dropdown_input}
\alias{update_dropdown_input}
\title{Update dropdown Semantic UI component}
\usage{
update_dropdown_input(
  session,
  input_id,
  choices = NULL,
  choices_value = choices,
  value = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{input_id}{The id of the input object}

\item{choices}{All available options one can select from. If no need to update then leave as \code{NULL}}

\item{choices_value}{What reactive value should be used for corresponding choice.}

\item{value}{A value to update dropdown to. Defaults to \code{NULL}.
\itemize{
  \item a value from \code{choices} updates the selection
  \item \code{character(0)} and \code{""} clear the selection
  \item \code{NULL}:
  \itemize{
    \item clears the selection if \code{choices} is provided
    \item otherwise, \code{NULL} does not change the selection
  }
  \item a value not found in \code{choices} does not change the selection
}}
}
\description{
Change the value of a \code{\link{dropdown_input}} input on the client.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shiny.semantic)

  ui <- semanticPage(
    title = "Dropdown example",
    dropdown_input("simple_dropdown", LETTERS[1:5], value = "A", type = "selection multiple"),
    p("Selected letter:"),
    textOutput("selected_letter"),
    shiny.semantic::actionButton("simple_button", "Update input to D")
  )

  server <- function(input, output, session) {
    output$selected_letter <- renderText(paste(input[["simple_dropdown"]], collapse = ", "))

    observeEvent(input$simple_button, {
      update_dropdown_input(session, "simple_dropdown", value = "D")
    })
  }

  shinyApp(ui, server)
}

}
