% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailwind_cli.R
\name{compile_tailwindcss}
\alias{compile_tailwindcss}
\title{Starts the 'TailwindCSS' CLI}
\usage{
compile_tailwindcss(
  infile,
  outfile,
  watch = FALSE,
  minify = FALSE,
  content = ".",
  tailwindcss = NULL,
  verbose = FALSE
)
}
\arguments{
\item{infile}{the 'TailwindCSS' file (eg containing the \verb{@tailwind} directives). Relative to basedir}

\item{outfile}{the target css file, where tailwind will write the css to.
Relative to basedir}

\item{watch}{if the files should be continuously monitored (versus only
compile the css once), default is False}

\item{minify}{if the code should be minified, default is FALSE}

\item{content}{content paths to remove unused classes, default is current dir}

\item{tailwindcss}{name and path to the executable}

\item{verbose}{print information}
}
\value{
the outfile invisibly
}
\description{
See also \href{https://tailwindcss.com/blog/standalone-cli}{tailwind docs}
}
\examples{
if (interactive()) {
  temp <- tempdir()
  owd <- setwd(temp)

  infile <- "custom.css"
  writeLines("@tailwind base;", infile)
  outfile <- "out.css"

  # file.copy(system.file("examples", "01-Old_Faithful", "app.R", package = "shiny.tailwind"),
  #           "app.R", overwrite = TRUE)

  # write a mini shiny UI
  writeLines("
    library(shiny)
    div(class = \"page-div\",
        div(class = \"w-full text-center py-12\",
            h1(\"Hello World\")
        )
    )", "app.R")

  tailwindcss <- NULL # can be set to the executable file
  compile_tailwindcss(infile, outfile, tailwindcss = tailwindcss)
  cat(paste(readLines(outfile)[1:20], collapse = "\n"))

  setwd(owd)
}
}
\seealso{
\link{install_tailwindcss_cli}
}
